 function updated_A = update_for_A_weighted(U_t, W_t, lambda_2, rho, E)
    dim1 = size(W_t,1);
    updated_A = zeros(size(W_t));
    for i = 1:dim1
        C = U_t(i,:) + W_t(i,:);
        C_l2 = sum(abs(C).^2)^(1/2);
        if(1-lambda_2/(rho*C_l2)) > 0
            updated_A(i,:) = (1-lambda_2*E(i)/(rho*C_l2))*C;
        else
            updated_A(i,:) = 0*C;
        end
    end
 end
